/* -*- mode: C; -*- */

/*
   Copyright (c) 1997-2002 MathEngine PLC

   $Name: t-stevet-RWSpre-030110 $

   Date: $Date: 2002/04/04 15:29:06 $ - Revision: $Revision: 1.3.2.5 $

   This software and its accompanying manuals have been developed
   by Mathengine PLC ("MathEngine") and the copyright and all other
   intellectual property rights in them belong to MathEngine. All
   rights conferred by law (including rights under international
   copyright conventions) are reserved to MathEngine. This software
   may also incorporate information which is confidential to
   MathEngine.

   Save to the extent permitted by law, or as otherwise expressly
   permitted by MathEngine, this software and the manuals must not
   be copied (in whole or in part), re-arranged, altered or adapted
   in any way without the prior written consent of the Company. In
   addition, the information contained in the software may not be
   disseminated without the prior written consent of MathEngine.
*/

/*
 * This is a skeleton app with a few useful utilities. It was generated by
 * the MathEngine code wizard. It contains functionality for loading a .KA
 * file and is designed to be used with KAT code export. To use with KAT
 * code export just export a file called asset,c over the existing asset.c.
 *
 * I hope you find this useful!
 */

#include <MeApp.h>
#include <MeAssetDB.h>
#include <MeAssetDBXMLIO.h>
#include <MeAssetFactory.h>
#include <RMenu.h>
#include <RGeometry.h>
#include <crtdbg.h>

extern "C" void MEAPI CreateAsset(McdFrameworkID fwk, McdSpaceID space, MdtWorldID world);

MstUniverseID           universe;
MstBridgeID             bridge;
McdSpaceID              space;
McdFrameworkID          fwk;
MdtWorldID              world;
MeAssetDB				*db = 0;
MeAssetFactory			*factory = 0;
MeAssetInstance			*ins = 0;
MeApp                   *app;
RRender                 *rc;
RMenu                   *mainMenu;
RMenu                   *visualsMenu;
RMenu                   *simMenu;

McdGeometryID           planeGeom;
McdModelID              plane;
RGraphic                *groundG;

MdtContactParamsID contactparams;
MeReal timestep = (MeReal)0.02;

/* visualization options */
int drawcollision = 1;
int drawcontacts = 1;
int drawDynamicsOrigins = 1;
int drawMassOrigins = 1;
int drawJoints = 1;

float geomcolor[] = {0,0,1,1};
float bodyOriginColor[] = {0,1,1,1};
float massOriginColor[] = {1,1,0,1};
float JointColor[] = {1,0,0,1};

RGraphic *RModelGraphic[200];
RGraphic *RBodyOrigin[200];
RGraphic *RMassOrigin[200];
RGraphic *RJoint[256];

MdtConstraintID jointID[256];
MeMatrix4 jointTM[256];

int nModelGraphics = 0;
int nBodyOrigins = 0;
int nMassOrigins = 0;
int nJoints = 0;

MeALIGNDATA(MeMatrix4,groundTM,16) = 
{
	{1,  0,  0, 0},
	{0,  0, -1, 0},
	{0,  1,  0, 0},
	{0, -1,  0, 1}
};

MeALIGNDATA(MeMatrix4,renderTM,16) = 
{
	{1,     0,  0, 0},
	{0,     0, -1, 0},
	{0,     1,  0, 0},
	{0, -1.05f,  0, 1}
};	

void MEAPI DrawCollisionGeom(MeBool b)
{
    McdSpaceModelIterator it;
    McdModelID model;
    int i=0;
    
    if (b)
	{
        McdSpaceModelIteratorBegin(app->space,&it);

        while(McdSpaceGetModel(app->space,&it,&model))
        {
            if (McdGeometryGetTypeId(McdModelGetGeometry(model)) == kMcdGeometryTypeNull)
                continue;
            RModelGraphic[i] = RGraphicCreateFromModel(app->rc,model,geomcolor);
            RGraphicSetWireframe(RModelGraphic[i],1);
            i++;
        }
        nModelGraphics = i;
    }
    else
	{
        for (i = 0; i < nModelGraphics; i++)
		{
            RGraphicDelete(app->rc,RModelGraphic[i],0);
            RModelGraphic[i] = NULL;
        }
        nModelGraphics = 0;
    }
}

void MEAPI DrawDynamicsOrigins(MeBool b)
{
    int i = 0;
    if (b)
	{
        MdtBodyID body;
        body = MdtBodyGetFirst(app->world);
        while (body)
		{
            RBodyOrigin[i] = RGraphicSphereCreate(app->rc,0.05f,bodyOriginColor,MdtBodyGetTransformPtr(body));
            body = MdtBodyGetNext(body);
            i++;
        }
        nBodyOrigins = i;
    }
    else
	{
        for (i = 0; i < nBodyOrigins; i++) 
		{
            RGraphicDelete(app->rc,RBodyOrigin[i],0);
            RBodyOrigin[i] = NULL;
        }
        nBodyOrigins = 0;
    }
}

void MEAPI DrawMassOrigins(MeBool b)
{
    int i = 0;
    if (b)
	{
        MdtBodyID body;
        body = MdtBodyGetFirst(app->world);
        while (body) {
            RMassOrigin[i] = RGraphicSphereCreate(app->rc,0.05f,massOriginColor,MdtBodyGetCenterOfMassTransformPtr(body));
            body = MdtBodyGetNext(body);
            i++;
        }
        nMassOrigins = i;
    }
    else 
	{
        for (i = 0; i < nMassOrigins; i++)
		{
            RGraphicDelete(app->rc,RMassOrigin[i],0);
            RMassOrigin[i] = NULL;
        }
        nMassOrigins = 0;
    }
}

void MEAPI UpdateJointGraphics(void)
{
    int i;

    for (i = 0; i < nJoints; i++)
	{
        MeMatrix4MultiplyMatrix(jointTM[i], jointID[i]->head.ref1, MdtBodyGetCenterOfMassTransformPtr(MdtConstraintGetBody(jointID[i],0)));
    }
}

void MEAPI DrawJointPositions(MeBool b)
{
    MdtConstraintID c;
    if (b)
	{
        c = MdtConstraintGetFirst(app->world);
        while (c)
		{
            jointID[nJoints] = c;
            MeMatrix4MultiplyMatrix(jointTM[nJoints], c->head.ref1, MdtBodyGetCenterOfMassTransformPtr(MdtConstraintGetBody(c,0)));
            RJoint[nJoints] = RGraphicSphereCreate(app->rc, 0.05f, JointColor, jointTM[nJoints]);
            nJoints++;
	        c = MdtConstraintGetNext(c);
        }
    }
    else
	{
        int i;
        for (i = 0; i < nJoints; i++)
		{
            RGraphicDelete(app->rc,RJoint[i],0);
            RJoint[i] = NULL;
            jointID[i] = NULL;
        }
        nJoints = 0;
    }
}

void MEAPI EnableAll(RRender *rc,void *userdata)
{
    MdtBodyID body;
    body = MdtBodyGetFirst(app->world);
    while (body)
    {
        MdtBodyEnable(body);
        body = MdtBodyGetNext(body);
    }
}

void MEAPI SetContactDrawLength(MeReal l)
{
    MeAppSetContactDrawLength(app,l);
}

void MEAPI ToggleDrawContacts(MeBool d)
{
    MeAppToggleDrawContacts(app,d);
}

void MEAPI SetGravityX(MeReal gx)
{
    MeVector3 g;
    MdtWorldGetGravity(world,g);
    MdtWorldSetGravity(world,-gx,g[1],g[2]);
}

void MEAPI SetGravityY(MeReal gy)
{
    MeVector3 g;
    MdtWorldGetGravity(world,g);
    MdtWorldSetGravity(world,g[0],-gy,g[2]);
}

void MEAPI SetGravityZ(MeReal gz)
{
    MeVector3 g;
    MdtWorldGetGravity(world,g);
    MdtWorldSetGravity(world,g[0],g[1],-gz);
}

void MEAPI SetTimestep(MeReal t)
{
    timestep = t;
}

void MEAPI SetFriction(MeReal f)
{
    MdtContactParamsSetFriction(contactparams, f);
    if (f == 0)
        MdtContactParamsSetType(contactparams, MdtContactTypeFrictionZero);
    else
        MdtContactParamsSetType(contactparams, MdtContactTypeFriction2D);
}

void MEAPI tick(RRender *rc,void *userdata)
{
    MstUniverseStep(universe,timestep);
    UpdateJointGraphics();
    MeAppStep(app);
}

void MEAPI single_step(RRender *rc,void *userdata)
{
    tick(rc,0);
}

void MEAPI_CDECL cleanup(void)
{
    DrawCollisionGeom(0);
    DrawDynamicsOrigins(0);
    DrawMassOrigins(0);
    DrawJointPositions(0);

	if (ins)
		MeAssetInstanceDestroy(ins);
	if (db)
		MeAssetDBDestroy(db);
	if (factory)
		MeAssetFactoryDestroy(factory);
    
	RRenderContextDestroy(rc);
    RMenuDestroy(mainMenu);
    RMenuDestroy(visualsMenu);
    RMenuDestroy(simMenu);
    MstUniverseDestroy(universe);
    MeAppDestroy(app);
}

void InitializeKarma(void)
{
	const MstUniverseSizes sizes = 
	{
		1024,      /*    dynamicBodiesMaxCount        */
		1024,      /*    dynamicConstraintsMaxCount   */
		0,         /*    collisionUserGeometryTypesMaxCount */
		1024,      /*    collisionModelsMaxCount      */
		1024,      /*    collisionPairsMaxCount       */
		1024,      /*    collisionGeometryInstancesMaxCount */
		16,        /*    materialsMaxCount            */
		1,         /*    lengthScale                  */
		1          /*    massScale                    */
	};

    universe = MstUniverseCreate(&sizes);

    world = MstUniverseGetWorld(universe);
    space = MstUniverseGetSpace(universe);
    bridge = MstUniverseGetBridge(universe);
    fwk = MstUniverseGetFramework(universe);

    MdtWorldSetGravity(world, 0, -10, 0);
    app = MeAppCreateFromUniverse(universe,rc);

    /* register all additionally required collision types */
    McdConvexMeshRegisterType(fwk);
    McdConvexMeshPrimitivesRegisterInteractions(fwk);

    /* set default contact parameters */

    contactparams = MstBridgeGetContactParams(bridge,
                                      MstBridgeGetDefaultMaterial(),
                                      MstBridgeGetDefaultMaterial());

    MdtContactParamsSetRestitution(contactparams, (MeReal)0.2);
    MdtContactParamsSetType(contactparams, MdtContactTypeFriction2D);
    MdtContactParamsSetFriction(contactparams, 1);
}

void LoadAndInstanceAsset()
{
	MeAssetDBXMLInput *input;
	MeStream stream;

    db = MeAssetDBCreate();
    input = MeAssetDBXMLInputCreate(db, 0);
    stream = MeStreamOpen("quadbike.ka", kMeOpenModeRDONLY);
    
	/* load XML and populate asset database */
    MeAssetDBXMLInputRead(input, stream);

    MeStreamClose(stream);
	
	/* destroy XML loader */
	MeAssetDBXMLInputDestroy(input);

	factory = MeAssetFactoryCreate(world, space, fwk);

	MeFAsset *asset = MeAssetDBLookupAssetByName(db, "quadbike");

	MeMatrix4 tm;
	MeMatrix4TMMakeIdentity(tm);
	MeMatrix4TMSetPosition(tm, 5, 0, 0);
	if (asset)
		ins = MeAssetInstanceCreate(factory, asset, tm, 1);
}

void InitializeRenderer()
{
    MeVector3 g;
    float contactcolor[] = {0,1,0,1};
    char *help[] =
    {
        "$MOUSE - applies force",
        "$ACTION1 - toggle options menu",
        "$ACTION3 - single step",
        "$ACTION4 - enable all"
    };

    MeAppDrawContactsInit(app, contactcolor, 256);
    
    MeAppToggleDrawContacts(app, drawcontacts);

    RCameraZoom(rc,-5);
    RCameraUpdate(rc);
    RRenderSetWindowTitle(rc, "MeExample");
    RRenderCreateUserHelp(app->rc,help,sizeof(help)/sizeof(help[0]));

    RRenderToggleUserHelp(app->rc);

    RRenderSetActionNCallBack(rc, 3, single_step, 0);
    RRenderSetActionNCallBack(rc, 4, EnableAll, 0);
    RRenderSetMouseCallBack(rc, MeAppMousePickCB, (void*)app);

    mainMenu = RMenuCreate(rc, "Main Menu");
    visualsMenu = RMenuCreate(rc, "Visualization Menu");
    simMenu = RMenuCreate(rc, "Simulation Menu");

    MdtWorldGetGravity(world,g);

    /* main menu */
    RMenuAddSubmenuEntry(mainMenu,"Visualization menu",visualsMenu);
    RMenuAddSubmenuEntry(mainMenu,"Simulation menu",simMenu);

    /* simulation menu */
    RMenuAddValueEntry(simMenu, "Gravity X", SetGravityX, 100, -10, 0.5f, -g[0]);
    RMenuAddValueEntry(simMenu, "Gravity Y", SetGravityY, 100, -10, 0.5f, -g[1]);
    RMenuAddValueEntry(simMenu, "Gravity Z", SetGravityZ, 100, -10, 0.5f, -g[2]);
    RMenuAddValueEntry(simMenu, "Timestep", SetTimestep,0.1f,0.01f,0.01f, timestep);
    RMenuAddValueEntry(simMenu, "Global friction", SetFriction,50,0,1,10);
    RMenuAddSubmenuEntry(simMenu,"Main menu",mainMenu);

    /* visualization menu */
    RMenuAddToggleEntry(visualsMenu, "Display collision geometry", DrawCollisionGeom, drawcollision);
    RMenuAddToggleEntry(visualsMenu, "Show dynamics origins", DrawDynamicsOrigins, drawDynamicsOrigins);
    RMenuAddToggleEntry(visualsMenu, "Show centres of mass", DrawMassOrigins, drawMassOrigins);
    RMenuAddToggleEntry(visualsMenu, "Display joint positions", DrawJointPositions, drawJoints);
    RMenuAddToggleEntry(visualsMenu, "Draw contacts", ToggleDrawContacts, drawcontacts);
    RMenuAddValueEntry(visualsMenu,  "Contact length scale factor", SetContactDrawLength,10,1,0.1f,1);
    RMenuAddSubmenuEntry(visualsMenu,"Main menu",mainMenu);

    RRenderSetDefaultMenu(rc, mainMenu);
    RPerformanceBarCreate(rc);

	/* create ground plane */
    {
	    planeGeom = McdPlaneCreate(fwk);
		plane = MstFixedModelCreate(universe,planeGeom,groundTM);
        float color[4];
        color[0] = color[1] = color[2] = color[3] = 1;
        groundG = RGraphicGroundPlaneCreate(rc, 24, 2, color, -1);
        RGraphicSetTexture(rc, groundG, "checkerboard");
    }

}

int MEAPI_CDECL main(int argc, const char **argv)
{
	MeCommandLineOptions *options = MeCommandLineOptionsCreate(argc, argv);
#if defined WIN32 && defined _DEBUG && 1
    {
        int debugFlag = _CrtSetDbgFlag(_CRTDBG_REPORT_FLAG);

        debugFlag |= _CRTDBG_ALLOC_MEM_DF;
        debugFlag |= _CRTDBG_CHECK_ALWAYS_DF;
        debugFlag |= _CRTDBG_LEAK_CHECK_DF;
        _CrtSetDbgFlag(debugFlag);
    }
#endif

    rc = RRenderContextCreate(options, 0, 1);
	MeCommandLineOptionsDestroy(options);

    InitializeKarma();
    InitializeRenderer();

#if 0
    /* This demonstrates loading a .KA file asset */
	LoadAndInstanceAsset();
#endif

    /* the implementation for this function is generated by KAT code export */
	CreateAsset(fwk, space, world);

    DrawCollisionGeom(drawcollision);
    DrawDynamicsOrigins(drawDynamicsOrigins);
    DrawMassOrigins(drawMassOrigins);
    DrawJointPositions(drawJoints);

#ifndef PS2
    atexit(cleanup);
#endif
    RRun(rc,tick,0);

    return 0;
}



